% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_conversions.R
\name{celsius.to.kelvin}
\alias{celsius.to.kelvin}
\title{Convert from Celsius to Kelvin.}
\usage{
celsius.to.kelvin(T.celsius, round = 2)
}
\arguments{
\item{T.celsius}{Numeric vector of temperatures in Celsius.}

\item{round}{An integer indicating the number of decimal places to
round the converted value.}
}
\value{
A numeric vector of temperature values in Kelvin.
}
\description{
\code{celsius.to.kelvin} creates a numeric vector of temperatures in
   Kelvin from a numeric vector of temperatures in Celsius.
}
\note{
Equations are from the source code for the National Oceanic and
     Atmospheric Association's
    \href{http://www.srh.noaa.gov/epz/?n=wxcalc_tempconvert}{online
    temperature converter}.
}
\examples{
# Convert from Celsius to Kelvin.
data(lyon)
lyon$TemperatureK <- celsius.to.kelvin(lyon$TemperatureC)
lyon

}
\author{
Joshua Ferreri \email{joshua.m.ferreri@gmail.com},
Brooke Anderson \email{brooke.anderson@colostate.edu}
}
\seealso{
\code{\link{kelvin.to.celsius}}
}

