% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{generate_bout_plot}
\alias{generate_bout_plot}
\title{Generate Bout Plot}
\usage{
generate_bout_plot(
  accelerometry_counts,
  gps_data,
  bout_number,
  leading_minutes = 8,
  trailing_minutes = 12,
  gps_target_size = 0.25,
  ...,
  collated_arguments = NULL
)
}
\arguments{
\item{accelerometry_counts}{A data frame or tibble containing accelerometry counts.}

\item{gps_data}{A data frame or tibble containing GPS data.}

\item{bout_number}{The number of the bout to be plotted.}

\item{leading_minutes}{number of minutes before a bout starts that we want to plot}

\item{trailing_minutes}{number of minutes after a bout ends that we want to plot}

\item{gps_target_size}{proportional size of circle plot}

\item{...}{Additional arguments to be passed to the function}

\item{collated_arguments}{A list of collated arguments}
}
\value{
A ggplot object representing the bout plot.
}
\description{
This function generates a plot of accelerometry counts and GPS radius for a specific bout.
}
