% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attendant.R
\name{Attendant}
\alias{Attendant}
\title{Attendant}
\description{
Manage the attendant loading bar with bootstrap 4.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{max}}{Maximum value of the bar.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Attendant-new}{\code{Attendant$new()}}
\item \href{#method-Attendant-inc}{\code{Attendant$inc()}}
\item \href{#method-Attendant-dec}{\code{Attendant$dec()}}
\item \href{#method-Attendant-set}{\code{Attendant$set()}}
\item \href{#method-Attendant-done}{\code{Attendant$done()}}
\item \href{#method-Attendant-close}{\code{Attendant$close()}}
\item \href{#method-Attendant-auto}{\code{Attendant$auto()}}
\item \href{#method-Attendant-getMin}{\code{Attendant$getMin()}}
\item \href{#method-Attendant-getMax}{\code{Attendant$getMax()}}
\item \href{#method-Attendant-getValue}{\code{Attendant$getValue()}}
\item \href{#method-Attendant-clone}{\code{Attendant$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-new"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$new(
  id,
  min = NULL,
  max = NULL,
  session = shiny::getDefaultReactiveDomain(),
  hide_on_max = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Id of progress bar set with [attendantBar].}

\item{\code{min, max}}{Minimum and maximum value of the progress bar.}

\item{\code{session}}{A valid shiny session.}

\item{\code{hide_on_max}}{Whether to hide the progress bar when
it reaches its maximum value (defined in [attendantBar]).
The progress bar automatically becomes visible again when
it is set to a value below the maximum.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise a progress bar
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-inc"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-inc}{}}}
\subsection{Method \code{inc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$inc(value = 1, text = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value to increase the progress bar.}

\item{\code{text}}{Text to display on the progress bar.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Increase
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-dec"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-dec}{}}}
\subsection{Method \code{dec()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$dec(value = 1, text = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value to decrease the progress bar.}

\item{\code{text}}{Text to display on the progress bar.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Decrease
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-set"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-set}{}}}
\subsection{Method \code{set()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$set(value, text = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value to set the progress bar.}

\item{\code{text}}{Text to display on the progress bar.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-done"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-done}{}}}
\subsection{Method \code{done()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$done(text = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{Text to display on the progress bar.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Done with progress
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-close"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-close}{}}}
\subsection{Method \code{close()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$close(text = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{Text to display on the progress bar.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Done with progress
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-auto"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-auto}{}}}
\subsection{Method \code{auto()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$auto(ms = 400, value = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ms}}{Milliseconds between increment of `value`.}

\item{\code{value}}{Value to increment by at every `ms`.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Automatically increase the progress bar until done
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-getMin"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-getMin}{}}}
\subsection{Method \code{getMin()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$getMin()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get minimum value
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-getMax"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-getMax}{}}}
\subsection{Method \code{getMax()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$getMax()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get maximum value
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-getValue"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-getValue}{}}}
\subsection{Method \code{getValue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$getValue()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get current value
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Attendant-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Attendant-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Attendant$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
