% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasure.R
\name{LowerSum}
\alias{LowerSum}
\title{Weighted lower sum}
\usage{
LowerSum(X, W = rep(1, length(X)), p = 0.5)
}
\arguments{
\item{X}{is a numeric data vector}

\item{W}{is a vector of weights}

\item{p}{is a probability to derive corresponding quantile}
}
\value{
The weighted sum of values not greater then a quantile.
}
\description{
Computes weighted sum of values not greater then a quantile derived for the given probability.
}
\details{
Calculates  weighted sum of values not greater then a quantile derived for the given probability based on cumulative distribution. Linear interpolation is applied to deal with a frequency distribution.
}
\examples{
# Suppose X represents incomes. Compare total incomes with incomes of poorer half of population.
X=1:10
W=10:1
sum(W*X)
LowerSum(X,W,0.5)


}
