% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{log_sum_exp}
\alias{log_sum_exp}
\alias{log_add2_exp}
\alias{log_sub2_exp}
\title{Log-Sum-Exp}
\usage{
log_sum_exp(x)

log_add2_exp(x, y)

log_sub2_exp(x, y)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector; it should have the same length as \code{x}.}
}
\value{
\code{log_add2_exp} and \code{log_sub2_exp} return a vector of pointwise results
whose \eqn{i}th element is the result based on \code{x[i]} and \code{y[i]}.
\code{log_sum_exp} returns a single scalar.
}
\description{
Compute arithmetic on the log-scale in a more stable way than directly
taking logarithm and exponentiating.
}
\details{
The function \code{log_sum_exp} computes \code{log(sum(exp(x)))} using the method in
StackExchange post \url{https://stats.stackexchange.com/a/381937}.

The functions \code{log_add2_exp} and \code{log_sub2_exp} compute
\code{log(exp(x) + exp(y))} and \code{log(exp(x) - exp(y))}, respectively.
The function \code{log_sub2_exp} expects that each element of \code{x} is
larger than or equal to its corresponding element in \code{y}. Otherwise,
\code{NaN} will be returned with a warning.
}
\examples{
pi = 1:6 / sum(1:6)
x = log(2*pi)
log(sum(exp(x)))
log_sum_exp(x)

# Result should be 0
x = c(-Inf -Inf, 0)
log_sum_exp(x)

# Result should be -Inf
x = c(-Inf -Inf, -Inf)
log_sum_exp(x)

# Result should be Inf
x = c(-Inf -Inf, Inf)
log_sum_exp(x)

# Result should be 5 on the original scale
out = log_add2_exp(log(3), log(2))
exp(out)

# Result should be 7 on the original scale
out = log_sub2_exp(log(12), log(5))
exp(out)

}
