% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Categorical}
\alias{Categorical}
\alias{r_categ}
\title{Categorical Distribution}
\usage{
r_categ(n, p, log = FALSE, one_based = FALSE)
}
\arguments{
\item{n}{Number of desired draws.}

\item{p}{Vector of \eqn{k} probabilities for distribution.}

\item{log}{logical; if \code{TRUE}, interpret \code{p} as being specified on the
log-scale as \code{log(p)}. Otherwise, interpret \code{p} as being specified on the
original probability scale.}

\item{one_based}{logical; if \code{TRUE}, assume a categorical distribution
with support \eqn{\{ 1, \ldots, k \}}. Otherwise, assume support
\eqn{\{ 0, \ldots, k - 1 \}}.}
}
\value{
A vector of \eqn{n} draws.
}
\description{
Draw variates from a categorical distribution.
}
\examples{
p = c(0.1, 0.2, 0.3, 0.4)
lp = log(p)

set.seed(1234)
r_categ(50, p, log = FALSE, one_based = FALSE)
r_categ(50, p, log = FALSE, one_based = TRUE)

set.seed(1234)
r_categ(50, lp, log = TRUE, one_based = FALSE)
r_categ(50, lp, log = TRUE, one_based = TRUE)

}
