% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strict_left_join.R
\name{strict_left_join}
\alias{strict_left_join}
\title{strict_left_join}
\usage{
strict_left_join(x, y, by = NULL, ...)
}
\arguments{
\item{x}{data frame x (left)}

\item{y}{data frame y (right)}

\item{by}{unquoted variable names to join.}

\item{...}{Pass further arguments to dplyr::left_join}
}
\value{
merged data frame
}
\description{
A wrapper around dplyr's left_join, with an error message if
duplicate values are present in the matching fields in y.
This will prevent duplicating rows. See dplyr::left_join .
}
\examples{
  left_df <- data.frame(id = c(1, 2, 3), name = c("Alice", "Bob", "Charlie"))
  right_df <- data.frame(id = c(1, 2, 4), age = c(20, 25, 30))
  strict_left_join(left_df, right_df, by = "id")

}
\seealso{
\code{\link[dplyr:join]{left_join}}
}
