% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volnmf_estimate.R
\name{volnmf_estimate}
\alias{volnmf_estimate}
\title{Alternating optimization of volume-regularized NMF}
\usage{
volnmf_estimate(
  B,
  C,
  R,
  Q,
  domain = "covariance",
  volf = "logdet",
  R.majorate = FALSE,
  wvol = NULL,
  delta = 1e-08,
  n.iter = 10000,
  err.cut = 1e-08,
  vol.iter = 100,
  c.iter = 100,
  extrapolate = TRUE,
  accelerate = TRUE,
  acc.C = 4/5,
  acc.R = 3/4,
  C.constraint = "col",
  C.bound = 1,
  R.constraint = "pos",
  verbose = TRUE,
  record = 100,
  Canchor = NULL,
  Ctrue = NULL,
  mutation.run = FALSE
)
}
\arguments{
\item{B}{A numeric matrix. A matrix to factorize (by default NULL). If not given than matrix \code{B} is taken to be a square root decomposition of \eqn{P = B*t(B)}.}

\item{C}{Numeric matrices. Initial matrices for optimiztion.}

\item{R}{Numeric matrices. Initial matrices for optimiztion.}

\item{Q}{Numeric matrices. Initial matrices for optimiztion.}

\item{domain}{A character. Optimize unitary rotation matrix \code{Q} ("covariance") or keep it as identity matrix (as in standard NMF). By default "covariance".}

\item{volf}{A character. Function that approximate volume. Can have values of "logdet" or "det" (by default "logdet").}

\item{R.majorate}{A boolean. Majorate logdet each iteration of \code{volnmf_logdet()} (by default FALSE).}

\item{wvol}{A numeric. A weight of volume-regularized term \code{volume(R)}.}

\item{delta}{A numeric. Logdet regularization term \code{log(det(R) + delta)} (by default 1e-8).}

\item{n.iter}{An integer. Number of iterations (by default \code{1,000}).}

\item{err.cut}{A numeric. Relative error in determinant between iterations to stop algorithm (by default \code{1e-8}).}

\item{vol.iter}{An integer. Number of iterations to update volume-regularized matrix \code{R} at each alternating step.}

\item{c.iter}{An integer. Number of iterations to update simplex matrix \code{C} at each alternating step.}

\item{extrapolate}{A numeric. Do Nesterov extrapolation inside blocks of R and C optimization (by default TRUE).}

\item{accelerate}{A numeric. Do acceleration each update after R and C blocks estimated via Nesterov-like extrapolation.}

\item{acc.C}{A numeric. Acceleration parameter of matrix C.}

\item{acc.R}{A numeric. Acceleration parameter of matrix R.}

\item{C.constraint}{A character. Constraint either sum of columns ("col") or sum of rows ("row) to be equal to \code{C.bound} (By default "col").}

\item{C.bound}{A numeric. A simplex constraint on matrix C vectors.}

\item{R.constraint}{A character. Set up non-negativity ("pos") constraint on elements of \code{R} (by default "pos", alternative "no").}

\item{verbose}{A boolean. Print per-iteration information (by default FALSE)}

\item{record}{A numeric. Record parameters every 'record' iterations (by default \code{NULL}).}

\item{Canchor}{A matrix. A matrix of anchor components (unused currently). (default=NULL)}

\item{Ctrue}{A matrix. Correct matrix C if known. Useful for benchmark.}

\item{mutation.run}{A boolean. Assess goodness of solution using reflection test if mutation.run=TRUE (applicable only to analysis of mutation patterns). (default=FALSE)}
}
\value{
List of objects:

\code{C, R, Q}, \code{E} Factorization matrices.

\code{iter, err} Number of iterations and relative per-iteration error \code{err} in matrix \code{C}.

\code{info.record} a list of objects that record and store state of matrices each \code{record} iterations.
}
\description{
\code{volnmf_estimate} provides alternating optimization of volume-regularized factorization of a matrix \code{B} using the following objective function:
\eqn{F = ||B*Q - C*R||^2 + w.vol*volume(R)}. Matrix \code{C} is required to be non-negative and having either column or row vectors on the simplex.
Matrix \code{R} can optionally have non-negativity constraint. Matrix \code{Q} can optionally be identity matrix or any unitary.
}
