% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vov.R
\name{fade_in_bottom_right}
\alias{fade_in_bottom_right}
\title{Fade in bottom right}
\usage{
fade_in_bottom_right(
  ui,
  duration = NULL,
  delay = NULL,
  steps = NULL,
  iteration = NULL
)
}
\arguments{
\item{ui}{A UI element}

\item{duration}{Duration of animation}

\item{delay}{Delay in seconds before animation starts}

\item{steps}{Animation steps}

\item{iteration}{Iteration of animation}
}
\description{
Animation to fade in a UI element from the bottom right.
}
\details{
\itemize{
        \item Duration expects one of: "fast" = 800 milliseconds, "faster" = 500 milliseconds, "fastest" = 300 milliseconds, "slow" = 2 seconds, "slower" = 3 seconds, "slowest" = 4 seconds,
        \item Delay expects one of: 0, 1, 2, 3, 4, 5, no delay if left NULL
        \item Steps expects one of: 10, 20, 30, 40, 50, no steps if left NULL
        \item Iteration expects one of: 1, 2, 3, 4, 5, infinite, no iteration if left NULL
      }
}
\examples{
if (interactive()) {
  library(shiny)
  library(vov)

  ui <- fluidPage(
    use_vov(),
    fade_in_bottom_right(
      h1("Hello world!")
    )
  )

  server <- function(input, output, session) {}

  shinyApp(ui, server)
}
}
