% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vt_d3.R
\name{vt_d3}
\alias{vt_d3}
\title{Voronoi Treemap in an htmlwidget}
\usage{
vt_d3(data, elementId = NULL, width = NULL, height = NULL,
  seed = NULL, title = NULL, legend = FALSE, legend_title = NULL,
  footer = NULL, label = TRUE, color_circle = "#aaaaaa",
  color_border = "#ffffff", color_label = "#000000",
  size_border = "1px", size_border_hover = "3px",
  size_circle = "2px")
}
\arguments{
\item{data}{a correct json data object}

\item{elementId}{optional a custom elementId to be returned}

\item{width}{width of the widget}

\item{height}{height of the widget}

\item{seed}{if defined, the plot is fixed}

\item{title}{NULL or a string for the title}

\item{legend}{TRUE/FALSE if a legend should be printed}

\item{legend_title}{NULL or a string for the title of the legend}

\item{footer}{NULL or a string for the footer text}

\item{label}{TRUE/FALSE if the labels should be printed}

\item{color_circle}{color for the outer circle}

\item{color_border}{color for the inner lines}

\item{color_label}{color for the label in the plot}

\item{size_border}{thickness of the borders in css style, e.g. '1px'}

\item{size_border_hover}{thickness of the borders when hovering in css style, e.g. '3px'}

\item{size_circle}{thickness of the circle in css style, e.g. '2px'}
}
\description{
Function to generate an htmlwidget with a voronoi treemap
}
\note{
The JavaScript library d3-voronoi treemap can be found here \url{https://github.com/Kcnarf/d3-voronoi-treemap}
  and the example is based on the
  remake of HowMuch.net's article 'The Global Economy by GDP' by _Kcnarf \url{https://bl.ocks.org/Kcnarf/fa95aa7b076f537c00aed614c29bb568}.
}
\examples{
vt_d3(vt_export_json(vt_testdata()))
data(ExampleGDP)
gdp_json <- vt_export_json(vt_input_from_df(ExampleGDP))
vt_d3(gdp_json)
data(canada)
canada$codes <- canada$h3
canada <- canada[canada$h1=="Canada",]
canadaH <- vt_input_from_df(canada,scaleToPerc = FALSE)
vt_d3(vt_export_json(canadaH))
#without label
vt_d3(vt_export_json(canadaH), label=FALSE)
#Example with coloring from scales package
library(scales)
canada$color <- seq_gradient_pal()(exp(canada$weight)/500)
canadaH <- vt_input_from_df(canada,scaleToPerc = FALSE)
vt_d3(vt_export_json(canadaH))
}
\references{
Arlind Nocaj and Ulrik Brandes. (2012). Computing Voronoi Treempas: Faster, Simpler and Resolution-independent.
Computer Graphics Forum. Vol.31. 855-864.
}
