% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulation}
\alias{simulation}
\title{Run Simulation of Death and Lapse Scenarios}
\usage{
simulation(
  df,
  n_sim = NULL,
  split = NULL,
  seed = NULL,
  sync_seed = TRUE,
  output_format = "csv",
  output_path = NULL
)
}
\arguments{
\item{df}{A data.frame returned by \code{make_portfolio()}}

\item{n_sim}{Number of simulations per split}

\item{split}{Number of splits (simulation repetitions)}

\item{seed}{Random seed (optional)}

\item{sync_seed}{Logical flag (default = TRUE). If TRUE, ensures that all policies
belonging to the same insured person use synchronized random seeds for death simulation,
thereby ensuring consistent timing of death events across policies. This is critical
for accurately capturing volatility risk arising from common mortality shocks.}

\item{output_format}{Output file format: "csv" or "parquet"}

\item{output_path}{Path to save the simulation results and logs}
}
\value{
No return value. Files are saved to \code{output_path}.
}
\description{
This function simulates death and lapse events over the insurance period
using the portfolio created by \code{make_portfolio()}. The total number of simulations
is \code{n_sim * split}, and results are saved in CSV or Parquet format in the specified path.
}
\examples{
# Prepare portfolio
port <- make_portfolio(example_portfolio, cols = list(
  unique_id = "POL_ID",
  client_id = "CLIENT_ID",
  duration = "DURATION",
  mortality = "MORTALITY",
  lapse = "LAPSE",
  nar = "NAR",
  rate = "RATE"
))

# Run simulation (output_path = tempdir() for demonstration)
simulation(port,
           n_sim = 10,
           split = 100,
           seed = 12345,
           output_format = "csv",
           output_path = tempdir()
           )
}
