% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_strapPnL.R
\name{strapPnL}
\alias{strapPnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Strap Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
strapPnL(
  ST,
  X,
  C1,
  C2,
  P,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C1}{Call Premium or Call Price paid for first bought Call.}

\item{C2}{Call Premium or Call Price paid for bought Call.}

\item{P}{Put Premium paid for the bought put.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This is a volatility strategy consisting of a long position in two ATM (at the money) calls , and a long position in an ATM (at the money) put option with a strike price X. This is a net debit trade. The trader or investor has bullish outlook (Kakushadze & Serur, 2018) .
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Strap Option Strategy and draw its graph in the Plots tab.
}
\examples{
strapPnL(25,25,2.40,2.40,1.70)
strapPnL(40,40,3,3,2,hl=0.7,hu=1.2)
strapPnL(1000,1010,18,18,10,hl=0.955,hu=1.055)
}
