% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likes.R
\name{likesGetListForObjects}
\alias{likesGetListForObjects}
\title{Returns a list of IDs of users who added the specified objects to their Likes list}
\usage{
likesGetListForObjects(
  objects,
  type = "post",
  filter = "likes",
  friends_only = 0,
  extended = 0,
  skip_own = 0,
  progress_bar = FALSE,
  v = getAPIVersion()
)
}
\arguments{
\item{objects}{List of objects (objects must contain fields owner_id and id)}

\item{type}{Object type (post or comment)}

\item{filter}{Filters to apply: likes - returns information about all users who liked the object (default); copies - returns information only about users who told their friends about the object}

\item{friends_only}{Specifies which users are returned: 1 - to return only the current user's friends; 0 - to return all users (default)}

\item{extended}{Specifies whether extended information will be returned. 1 - to return extended information about users and communities from the Likes list; 0 - to return no additional information (default)}

\item{skip_own}{flag, either 1 or 0}

\item{progress_bar}{Display progress bar}

\item{v}{Version of API}
}
\description{
Returns a list of IDs of users who added the specified objects to their Likes list
}
\examples{
\dontrun{
wall <- getWallExecute(domain = 'privivkanet', count = 10, progress_bar = TRUE)
post_likers <- likesGetListForObjects(wall, type = 'post', progress_bar = TRUE)
post_likers_extended <- likesGetListForObjects(wall, type = 'post',
   extended = 1, progress_bar = TRUE)
}
}
