% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_clustering.R
\name{cut_clusters}
\alias{cut_clusters}
\title{Cut a hierarchical tree targeting k clusters}
\usage{
cut_clusters(clusters, k)
}
\arguments{
\item{clusters}{cluster results, produced by e.g. \code{\link[fastcluster:hclust]{fastcluster::hclust()}}}

\item{k}{target number of clusters}
}
\value{
cluster labels
}
\description{
Cut a hierarchical tree targeting k clusters
}
\examples{
dmat <- compute_dmat(iris, "euclidean", TRUE, c("Petal.Length", "Sepal.Length"))
clusters <- compute_clusters(dmat, "complete")
cluster_labels <- cut_clusters(clusters, 2)
head(cluster_labels)
}
