% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compdesc.R
\name{compdesc}
\alias{compdesc}
\title{Components descriptive analysis}
\usage{
compdesc(model, sep = "+", heatmap = TRUE, percentage = TRUE, digits = 2)
}
\arguments{
\item{model}{An object of class \code{\link[netmeta]{netmeta}}.}

\item{sep}{A single character that defines the separator between interventions components.}

\item{heatmap}{\code{logical}. If \code{TRUE} a heat matrix of the component's frequency is plotted.}

\item{percentage}{\code{logical}. If \code{TRUE} combinations' percentages are printed as a number instead of fraction value in the \code{heatmap}.}

\item{digits}{A single integer value that specifies the percentages' decimal places in the \code{heatmap}.}
}
\value{
A list containing three items
\item{crosstable}{A cross-table containing the frequency of the components. Each cell represents the number of arms where the corresponding component combination was observed.}
\item{frequency}{A \code{data.frame} that contains the component's frequency. Columns
\itemize{ \item{ \code{Component}} {denotes the name of each component}
 \item{\code{Frequency}} {denotes the number of arms where the component was observed}
 \item{\code{A}} {denotes the number of studies in which the corresponding component was included in all arms}
 \item{\code{A_percent}} {denotes the percentage of studies in which the corresponding component was included in all arms}
 \item{\code{B}} {denotes the number of studies in which the corresponding component was included in at least one arm}
 \item{\code{B_percent}} {denotes the percentage of studies in which the corresponding component was included in at least one arm}
 \item{\code{C}} {denotes the number of studies in which the corresponding component was not included in any arm}
 \item{\code{C_percent}} {denotes the percentage of studies in which the corresponding component was not included in any arm}
 \item{\code{A.B}} {denotes the ratio of columns \code{A} and \code{B}}.
  }}
  \item{heatmat}{An object of class \code{ggplot} that visualizes item \code{crosstable}. Diagonal elements refer to the components and in parentheses the proportion of study
  arms including that component is provided, while off-diagonal elements to the frequency of component’s combinations and in parentheses the proportion of study arms with both components
  out of those study arms that have the component in the row is provided. Also, the intensity of the color is proportional to the relative frequency of the component combination.}
}
\description{
The function performs a descriptive analysis regarding the frequency of the components in the network meta-analysis model.
}
\note{
The function can be applied only in network meta-analysis models that contain multi-component interventions.
}
\examples{
data(nmaMACE)
compdesc(model = nmaMACE)

}
