% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatTable.R
\name{formatTable}
\alias{formatTable}
\title{Creates a flextable or gt object from a dataframe}
\usage{
formatTable(
  x,
  type = NULL,
  delim = "\\n",
  style = NULL,
  na = "–",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  groupColumn = NULL,
  groupAsColumn = FALSE,
  groupOrder = NULL,
  merge = "all_columns"
)
}
\arguments{
\item{x}{A dataframe.}

\item{type}{Character string specifying the desired output table format.
See \code{tableType()} for supported table types. If \code{type = NULL}, global
options (set via \code{setGlobalTableOptions()}) will be used if available;
otherwise, a default \code{'gt'} table is created.}

\item{delim}{Delimiter to separate headers.}

\item{style}{Defines the visual formatting of the table.
This argument can be provided in one of the following ways:
\enumerate{
\item \strong{Pre-defined style:} Use the name of a built-in style (e.g., \code{"darwin"}).
See \code{tableStyle()} for available options.
\item \strong{YAML file path:} Provide the path to an existing \code{.yml} file defining
a new style.
\item \strong{List of custome R code:} Supply a block of custom R code or a named list
describing styles for each table section. This code must be specific to
the selected table type.
If \code{style = NULL}, the function will use global options
(see \code{setGlobalTableOptions()}) or an existing \verb{_brand.yml} file (if found);
otherwise, the default style is applied.
For more details, see the \emph{Styles} vignette on the package website.
}}

\item{na}{How to display missing values. Not used for "datatable" and
"reactable".}

\item{title}{Title of the table, or NULL for no title. Not used for
"datatable".}

\item{subtitle}{Subtitle of the table, or NULL for no subtitle. Not used for
"datatable" and "reactable".}

\item{caption}{Caption for the table, or NULL for no caption. Text in
markdown formatting style (e.g. \verb{*Your caption here*} for caption in
italics). Not used for "reactable".}

\item{groupColumn}{Columns to use as group labels, to see options use
\code{tableColumns(result)}. By default, the name of the new group will be the
tidy* column names separated by ";". To specify a custom group name, use a
named list such as:
list("newGroupName" = c("variable_name", "variable_level")).

*tidy: The tidy format applied to column names replaces "_" with a space and
converts to sentence case. Use \code{rename} to customise specific column names.}

\item{groupAsColumn}{Whether to display the group labels as a column
(TRUE) or rows (FALSE). Not used for "datatable" and "reactable"}

\item{groupOrder}{Order in which to display group labels. Not used for
"datatable" and "reactable".}

\item{merge}{Names of the columns to merge vertically when consecutive row
cells have identical values. Alternatively, use "all_columns" to apply this
merging to all columns, or use NULL to indicate no merging. Not used for
"datatable" and "reactable".}
}
\value{
A formatted table of the class selected in "type" argument.
}
\description{
Creates a flextable object from a dataframe using a delimiter to span
the header, and allows to easily customise table style.
}
\examples{
# Example 1
mockSummarisedResult() |>
  formatEstimateValue(decimals = c(integer = 0, numeric = 1)) |>
  formatHeader(
    header = c("Study strata", "strata_name", "strata_level"),
    includeHeaderName = FALSE
  ) |>
  formatTable(
    type = "flextable",
    style = "default",
    na = "--",
    title = "fxTable example",
    subtitle = NULL,
    caption = NULL,
    groupColumn = "group_level",
    groupAsColumn = TRUE,
    groupOrder = c("cohort1", "cohort2"),
    merge = "all_columns"
  )

# Example 2
mockSummarisedResult() |>
  formatEstimateValue(decimals = c(integer = 0, numeric = 1)) |>
  formatHeader(header = c("Study strata", "strata_name", "strata_level"),
              includeHeaderName = FALSE) |>
  formatTable(
    type = "gt",
    style = list("header" = list(
      gt::cell_fill(color = "#d9d9d9"),
      gt::cell_text(weight = "bold")),
      "header_level" = list(gt::cell_fill(color = "#e1e1e1"),
                            gt::cell_text(weight = "bold")),
      "column_name" = list(gt::cell_text(weight = "bold")),
      "title" = list(gt::cell_text(weight = "bold"),
                     gt::cell_fill(color = "#c8c8c8")),
      "group_label" = gt::cell_fill(color = "#e1e1e1")),
    na = "--",
    title = "gtTable example",
    subtitle = NULL,
    caption = NULL,
    groupColumn = "group_level",
    groupAsColumn = FALSE,
    groupOrder = c("cohort1", "cohort2"),
    merge = "all_columns"
  )

}
