% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterative_grid_search.R
\name{iterative_grid_search}
\alias{iterative_grid_search}
\title{Iterative Grid Search}
\usage{
iterative_grid_search(
  X,
  y,
  q_list,
  Q_init = NULL,
  max_iter = 0,
  delay = 1,
  use = NULL,
  restrict = NULL,
  mode = "gaussian",
  p1 = 0,
  ncores = 1,
  train_theta1 = NULL,
  train_Q = NULL,
  verbose = TRUE
)
}
\arguments{
\item{X}{the explanatory variables}

\item{y}{the observations}

\item{q_list}{the possible values of \code{diag(Q) / sig^2}}

\item{Q_init}{(default \code{NULL}) initial value of \code{Q / sig^2},
if \code{NULL} it is set to 0}

\item{max_iter}{(optional 0) maximal number of iterations. If 0 then optimization is
done as long as we can improve the log-likelihood}

\item{delay}{(optional, default 1) to predict \code{y[t]} we have access to \code{y[t-delay]}}

\item{use}{(optional, default \code{NULL}) the availability variable}

\item{restrict}{(optional, default \code{NULL}) if not \code{NULL} it allows to specify the
indices of the diagonal coefficient to optimize}

\item{mode}{(optional, default \code{gaussian})}

\item{p1}{(optional, default \code{0}) coefficient for \code{P1/sig^2 = p1 I}}

\item{ncores}{(optional, default \code{1}) number of available cores for computation}

\item{train_theta1}{(optional, default \code{NULL}) training set for estimation of \code{theta1}}

\item{train_Q}{(optional, default \code{NULL}) time steps on which the log-likelihood is computed}

\item{verbose}{(optional, default \code{TRUE}) whether to print intermediate progress}
}
\value{
a list containing values for \code{P,theta,sig,Q}, as well as \code{LOGLIK},
the evolution of the log-likelihood during the search.
}
\description{
\code{iterative_grid_search} is an iterative method to choose hyper-parameters of
the linear Gaussian State-Space Model with time-invariant variances.
}
\details{
We restrict ourselves to a diagonal matrix \code{Q} and we optimize \code{Q / sig^2} on
a grid. Each diagonal coefficient is assumed to belong to a pre-defined \code{q_list}.\cr
We maximize the log-likelihood on that region of search in an iterative fashion.
At each step, we change the diagonal coefficient improving the most the log-likelihood.
We stop when there is no possible improvement. This doesn't guarantee an optimal point
on the grid, but the computational time is much lower.
}
\examples{
set.seed(1)
### Simulate data
n <- 100
d <- 5
Q <- diag(c(0,0,0.25,0.25,0.25))
sig <- 1

X <- cbind(matrix(rnorm((d-1)*n,sd=1),n,d-1),1)
theta <- matrix(rnorm(d), d, 1)
theta_arr <- matrix(0, n, d)
for (t in 1:n) {
  theta_arr[t,] <- theta
  theta <- theta + matrix(mvtnorm::rmvnorm(1,matrix(0,d,1),Q),d,1)
}
y <- rowSums(X * theta_arr) + rnorm(n, sd=sig)

l <- viking::iterative_grid_search(X, y, seq(0,1,0.25))
print(l$Q)
print(l$sig)
}
