% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{pull_from_list}
\alias{pull_from_list}
\title{Safely pull an item from a list}
\usage{
pull_from_list(x, ..., fail_if_null = TRUE)
}
\arguments{
\item{x}{List to pull items from}

\item{...}{List indices to pull. Can be either numeric or (preferably) a character.}

\item{fail_if_null}{(logical, default TRUE). Returns an informative error message if
the list index is NULL. This function must always be named.}
}
\description{
Indexing function for a list
}
\details{
Use the \code{...} arguments to index the list. Not passing any \code{...} arguments
will return the entire list. The indexing will fail if either of two conditions are
met:
\enumerate{
\item The index (which can be numeric or a key) does not exist in the list
\item If the index exists but the value of the item is NULL, and \code{fail_if_null} is TRUE
}
}
