% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosstable.R
\name{crosstable}
\alias{crosstable}
\alias{crosstable,formula,data.frame-method}
\alias{crosstable,formula,vegtable-method}
\alias{cross2db}
\alias{cross2db.data.frame}
\alias{cross2db,data.frame-method}
\alias{cross2db.matrix}
\alias{cross2db,matrix-method}
\title{Generating cross tables from database lists}
\usage{
crosstable(formula, data, ...)

\S4method{crosstable}{formula,data.frame}(
  formula,
  data,
  FUN,
  na_to_zero = FALSE,
  use_nas = TRUE,
  as_matrix = FALSE,
  ...
)

\S4method{crosstable}{formula,vegtable}(
  formula,
  data,
  FUN,
  level,
  include_lower = FALSE,
  na_to_zero = FALSE,
  use_nas = TRUE,
  ...
)

cross2db(object, ...)

\method{cross2db}{data.frame}(object, layers = FALSE, na_strings, ...)

\method{cross2db}{matrix}(object, ...)
}
\arguments{
\item{formula}{A formula indicating the variables used in the cross table.
This formula can be represented as \code{'abundance ~ cols + rows'}, where
\code{'abundance'} is the numeric variable quantified for a row in a column,
for instance the abundance of a species in a plot.
Further variables can be set as additional rows indices in a cross table.}

\item{data}{Either a data frame or an object of class \linkS4class{vegtable}.}

\item{...}{Further arguments passed to the function \code{\link[stats:aggregate]{stats::aggregate()}}.}

\item{FUN}{Function used to aggregate values in the case of a multiple
occurrence of a species in a plot, for instance.}

\item{na_to_zero}{A logical value indicating whether zeros should be
inserted into empty cells or not.}

\item{use_nas}{Logical value indicating whether NAs should be considered as
levels for categorical variables or not.}

\item{as_matrix}{A logical value, whether output should be done as matrix or
data frame.}

\item{level}{A character vector with taxonomic ranks (levels) requested in
the cross table.}

\item{include_lower}{A logical value indicating wether lower value to the
requested levels should be merged or not. It works only if \code{'level'} is
not missing. Note that if you like to include higher ranks or rankless
taxa in the cross table, you will rahter need to run
\code{\link[taxlist:merge_taxa]{taxlist::merge_taxa()}} on slot \strong{species}.}

\item{object}{A data frame or a matrix including a cross table. Note that
\code{cross2db()} assumes observations as columns and species (and layers)
as rows in the \code{data.frame-method} but species as columns and
observations as rows in the \code{matrix-method}.}

\item{layers}{Logical value, whether the cross table includes a layer column
or not.}

\item{na_strings}{Character vector indicating no records in the cross table.}
}
\value{
An object of class \link{data.frame}.
}
\description{
cross table is the most common format required by statistical packages
used to analyse vegetation data (e.g.
\href{https://CRAN.R-project.org/package=vegan}{vegan}).

You may use for convenience a formula as
\code{'abundance ~ plot + species + ...'}.
Additional variables used for rows (\code{...}) can be for instance the
layers.
For objects of class \linkS4class{vegtable}, the formula can also include
variables from the species list (for example \code{AcceptedName}, \code{AuthorName})
or even taxon traits.

If required, tables already formatted as cross tables can be converted into
column-oriented tables by using the function \code{cross2db()}.
}
\examples{
# Produce a subset
veg <- subset(Kenya_veg, REFERENCE == 2331, slot = "header")

## transform cover to percentage
veg <- cover_trans(veg, to = "cover_perc", rule = "middle")

## cross table of the first 5 plots
Cross <- crosstable(cover_perc ~ ReleveID + AcceptedName + AuthorName,
  data = veg[1:5, ], FUN = mean, na_to_zero = TRUE)
head(Cross)

## cross table of recorded genera
Cross <- crosstable(cover_perc ~ ReleveID + AcceptedName + AuthorName,
    data = veg, FUN = mean, level = "genus")
head(Cross[ , 1:7])

## cross table of data merged to genus
Cross <- crosstable(cover_perc ~ ReleveID + AcceptedName + AuthorName,
    data = veg, FUN = sum, level = "genus", include_lower = TRUE)
head(Cross[ , 1:7])

## the same for families
Cross <- crosstable(cover_perc ~ ReleveID + AcceptedName + AuthorName,
    data = veg, FUN = sum, level = "family", include_lower = TRUE)
head(Cross[ , 1:7])
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
