% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.cronbach}
\alias{replicate.cronbach}
\title{Compares and combines Cronbach reliablity in original and follow-up studies}
\usage{
replicate.cronbach(alpha, rel1, n1, rel2, n2, r)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{rel1}{estimated reliability in original study}

\item{n1}{sample size in original study}

\item{rel2}{estimated reliability in follow-up study}

\item{n2}{sample size in follow-up study}

\item{r}{number of measurements (e.g., items)}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference in correlations
\item Row 4 estimates the average correlation
}

The columns are:
\itemize{
\item Estimate - correlation estimate (single study, difference, average)
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function can be used to compare and combine a Cronbach reliablity
coefficient from an original study and a follow-up study. The confidence
level for the difference is 1 – 2*alpha, which is recommended for
equivalence testing.
}
\examples{
replicate.cronbach(.05, .883, 100, .869, 200, 6)

# Should return:
#                       Estimate         SE          LL         UL
# Original:                0.883 0.01830958  0.84356871 0.91522517
# Follow-up:               0.869 0.01442263  0.83874629 0.89523760
# Original - Follow-up:    0.014 0.02330779 -0.03336284 0.05820123
# Average:                 0.876 0.01172239  0.85187755 0.89774525


}
\references{
\itemize{
\item \insertRef{Bonett2010}{vcmeta}
\item \insertRef{Bonett2015}{vcmeta}
\item \insertRef{Bonett2021}{vcmeta}
}
}
