% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Gilby}
\alias{Gilby}
\title{Clothing and Intelligence Rating of Children}
\format{
A 2-dimensional array resulting from cross-tabulating 2 variables
for 1725 observations. The variable names and their levels are:

\tabular{rll}{
No \tab Name \tab Levels \cr
1\tab \code{Dullness}\tab \verb{"Ment. defective", "Slow", "Slow Intell", "Fairly Intell", "Capable", "V.Able"}\cr
2\tab \code{Clothing}\tab \verb{"V.Well clad", "Well clad", "Passable", "Insufficient"}\cr
}
}
\source{
Anscombe, F. J. (1981). \emph{Computing in Statistical Science Through APL}. New York: Springer-Verlag, p. 302
}
\description{
Schoolboys were classified according to their clothing and to their teachers
rating of "dullness" (lack of intelligence), in a 5 x 7 table originally
from Gilby (1911). Anscombe (1981) presents a slightly collapsed 4 x 6
table, used here, where the last two categories of clothing were pooled as
were the first two categories of dullness due to small counts.
}
\details{
Both \code{Dullness} and \code{Clothing} are ordered categories, so models
and methods that examine their association in terms of ordinal categories
are profitable.
}
\examples{

data(Gilby)

# CMH tests treating row/column variables as ordinal
CMHtest(Gilby)

mosaic(Gilby, shade=TRUE)

# correspondence analysis to see relations among categories
if(require(ca)){
	ca(Gilby)
	plot(ca(Gilby), lines=TRUE)

}



}
\references{
Gilby, W. H. (1911).
On the significance of the teacher's appreciation of general
intelligence.  \emph{Biometrika}, 8, 93-108 (esp. p. 94).  (Quoted by Kendall (1943,..., 1953) Table 13.1, p 320.)
}
\keyword{datasets}
