% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vault_client_policy.R
\name{vault_client_policy}
\alias{vault_client_policy}
\title{Vault Policy Configuration}
\description{
Vault Policy Configuration

Vault Policy Configuration
}
\details{
Interact with vault's policies.  To get started, you may want to
read up on policies as described in the vault manual, here:
https://developer.hashicorp.com/vault/docs/concepts/policies
}
\examples{
server <- vaultr::vault_test_server(if_disabled = message)
if (!is.null(server)) {
  client <- server$client()

  # The test server starts with only the policies "root" (do
  # everything) and "default" (do nothing).
  client$policy$list()

  # Here let's make a policy that allows reading secrets from the
  # path /secret/develop/* but nothing else
  rules <- 'path "secret/develop/*" {policy = "read"}'
  client$policy$write("read-secret-develop", rules)

  # Our new rule is listed and can be read
  client$policy$list()
  client$policy$read("read-secret-develop")

  # For testing, let's create a secret under this path, and under
  # a different path:
  client$write("/secret/develop/password", list(value = "password"))
  client$write("/secret/production/password", list(value = "k2e89be@rdC#"))

  # Create a token that can use this policy:
  token <- client$auth$token$create(policies = "read-secret-develop")

  # Login to the vault using this token:
  alice <- vaultr::vault_client(addr = server$addr,
                                login = "token", token = token)

  # We can read the paths that we have been granted access to:
  alice$read("/secret/develop/password")

  # We can't read secrets that are outside our path:
  try(alice$read("/secret/production/password"))

  # And we can't write:
  try(alice$write("/secret/develop/password", list(value = "secret")))

  # cleanup
  server$kill()
}
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_client_policy}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-vault_client_policy-new}{\code{vault_client_policy$new()}}
\item \href{#method-vault_client_policy-delete}{\code{vault_client_policy$delete()}}
\item \href{#method-vault_client_policy-list}{\code{vault_client_policy$list()}}
\item \href{#method-vault_client_policy-read}{\code{vault_client_policy$read()}}
\item \href{#method-vault_client_policy-write}{\code{vault_client_policy$write()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-format'><code>vaultr::vault_client_object$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-help'><code>vaultr::vault_client_object$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_policy-new"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_policy-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{vault_client_policy} object. Not typically
called by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_policy$new(api_client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_client}}{A \link{vault_api_client} object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_policy-delete"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_policy-delete}{}}}
\subsection{Method \code{delete()}}{
This endpoint deletes the policy with the given
name. This will immediately affect all users associated with
this policy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_policy$delete(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Specifies the name of the policy to delete.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_policy-list"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_policy-list}{}}}
\subsection{Method \code{list()}}{
Lists all configured policies.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_policy$list()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_policy-read"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_policy-read}{}}}
\subsection{Method \code{read()}}{
Retrieve the policy body for the named policy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_policy$read(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Specifies the name of the policy to retrieve}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_client_policy-write"></a>}}
\if{latex}{\out{\hypertarget{method-vault_client_policy-write}{}}}
\subsection{Method \code{write()}}{
Create or update a policy.  Once a policy is
updated, it takes effect immediately to all associated users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_client_policy$write(name, rules)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the policy to update}

\item{\code{rules}}{Specifies the policy document.  This is a string
in "HashiCorp configuration language".  At present this must
be read in as a single string (not a character vector of
strings); future versions of vaultr may allow more flexible
specification such as \verb{@filename}}
}
\if{html}{\out{</div>}}
}
}
}
