tmd_ft=function(y,x,fpf=0.3,pval="no",B=2000){

  #0.data frame
  df=data.frame(y=y,x=x)
  n=nrow(df)
  n0=sum(df$y==0)
  n1=sum(df$y==1)

  #1. ROC & tmd at all points
  roc_fit=stsp.cal(y=y,x=x)
  res1=roc_fit$res1
  auc1=roc_fit$auc

  res1=tmd.cal(y=y,x=x,res1=res1) #tmd at all th
  res2=itmd.cal(res1=res1,auc=auc1) #itmd
  #res3=res1[tail(which(res1$fpf>=fpf),1),] #tmd at fpf

  #3. bootstrap p-values
  res1$pvalue=NA
  res2$pvalue=NA

  if(pval=="yes"){
    K=length(res1$fpf)

    tmd_b=matrix(NA,B,K)
    itmd_b=rep(NA,B)
    for(b in 1:B){
      df_b=df[sample(1:n,replace=TRUE),]
      df_b$y=1
      df_b$y[1:n0]=0

      y_b=df_b$y
      x_b=df_b$x

      roc_fit_b=stsp.cal(y=y_b,x=x_b)
      res1_b=roc_fit_b$res1
      auc1_b=roc_fit_b$auc

      res1_b=tmd.cal(y=y,x=x,res1=res1_b) #tmd at all th
      for(k in 1:K)
        tmd_b[b,k]=res1_b[tail(which(res1_b$fpf>=res1$fpf[k]),1),]$tmd #tmd at fpf

      itmd_b[b]=itmd.cal(res1=res1_b,auc=auc1_b)$itmd #itmd
    }

    for(k in 1:K)
      res1$pvalue[k]=mean(tmd_b[,k]>=res1$tmd[k])

    res2$pvalue=mean(itmd_b>=res2$itmd)
  }

  return(list(res1=res1,res2=res2))
}
