% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_tbl.R
\name{importance_tbl}
\alias{importance_tbl}
\title{Extract the importance data frame}
\usage{
importance_tbl(importance, name = "importance_tbl")
}
\arguments{
\item{importance}{A jobj from the class \code{ImportanceAnalysis}, usually the
output of \code{vs_importance_analysis()}.}

\item{name}{The name to assign to the copied table in Spark.}
}
\description{
This function extracts the importance data frame from the Importance Analysis
jobj.
}
\examples{
\dontrun{
library(sparklyr)
sc <- spark_connect(master = "local")
vsc <- vs_connect(sc)

hipster_vcf <- vs_read_vcf(vsc, 
                           system.file("extdata/hipster.vcf.bz2",
                                       package = "variantspark"))
labels <- vs_read_labels(vsc, 
                         system.file("extdata/hipster_labels.txt",
                                      package = "variantspark"))

importance <- vs_importance_analysis(vsc, hipster_vcf, labels, 10)
importance_tbl(importance)
}

}
