% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varband_path.R
\name{varband_path}
\alias{varband_path}
\title{Solve main optimization problem along a path of lambda}
\usage{
varband_path(S, w = FALSE, lasso = FALSE, lamlist = NULL, nlam = 60,
  flmin = 0.01)
}
\arguments{
\item{S}{The sample covariance matrix}

\item{w}{Logical. Should we use weighted version of the penalty or not? If \code{TRUE}, we use general weight. If \code{FALSE}, use unweighted penalty. Default is \code{FALSE}.}

\item{lasso}{Logical. Should we use l1 penalty instead of hierarchical group lasso penalty? Note that by using l1 penalty, we lose the banded structure in the resulting estimate. And when using l1 penalty, the becomes CSCS (Convex Sparse Cholesky Selection) introduced in Khare et al. (2016). Default value for \code{lasso} is \code{FALSE}.}

\item{lamlist}{A list of non-negative tuning parameters \code{lambda}.}

\item{nlam}{If lamlist is not provided, create a lamlist with length \code{node}. Default is 60.}

\item{flmin}{if lamlist is not provided, create a lamlist with ratio of the smallest and largest lambda in the list. Default is 0.01.}
}
\value{
A list object containing \describe{
\item{path: }{A array of dim (\code{p}, \code{p}, \code{nlam}) of estimates of L}
\item{lamlist: }{a grid values of tuning parameters}
}
}
\description{
Compute the varband estimates along a path of tuning parameter values.
}
\examples{
set.seed(123)
n <- 50
true <- varband_gen(p = 50, block = 5)
x <- sample_gen(L = true, n = n)
S <- crossprod(scale(x, center = TRUE, scale = FALSE))/n
path_res <- varband_path(S = S, w = FALSE, nlam = 40, flmin = 0.03)
}
\seealso{
\code{\link{varband}} \code{\link{varband_cv}}
}

