% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chiplot.R
\name{chiplot}
\alias{chiplot}
\title{Chi Square Plot}
\usage{
chiplot(
  zmat,
  method = "square",
  type = "full",
  ggtheme = ggplot2::theme_classic(),
  title = "",
  show.legend = TRUE,
  legend.title = "Z",
  colors = c("dodgerblue3", "white", "firebrick2"),
  outline.color = "white",
  lab = FALSE,
  lab_col = "black",
  lab_size = 4,
  p.mat = NULL,
  z.crit = NULL,
  sig.level = 0.05,
  insig = pch,
  pch = 4,
  pch.col = "black",
  pch.cex = 5,
  tl.cex = 12,
  tl.col = "black",
  tl.srt = 45,
  digits = 2,
  as.is = FALSE
)
}
\arguments{
\item{zmat}{a matrix of standardized residuals, extracted from the chi square test, to visualize.}

\item{method}{the type of visualization used in plot (default set to \code{"square"}).}

\item{type}{the section of the plot that will be displayed (default set to \code{"full"}).}

\item{ggtheme}{\code{ggplot2} function to set the theme of the plot (default set to \code{ggplot2::theme_classic()}).}

\item{title}{title of the plot, extracted from the chi square test.}

\item{show.legend}{logical (default set to \code{TRUE}), to display legend on plot.}

\item{legend.title}{title of the legend (default set to \code{"Z"}).}

\item{colors}{a vector of 3 colors for negative, zero, and positive residuals.}

\item{outline.color}{the outline color of the square (default set to \code{"white"}).}

\item{lab}{logical (default set to \code{FALSE}, but set to \code{TRUE} if extracted from chi square test), to display standardized residual (Z) value (and significance stars) on for each cell comparison on the plot.}

\item{lab_col}{color of text displayed in each cell comparison for standardized residual (Z) value when \code{lab = TRUE} (default set to \code{"black"}).}

\item{lab_size}{size of text displayed in each cell comparison for standardized residual (Z) value when \code{lab = TRUE} (default set to \code{4}).}

\item{p.mat}{a matrix of p-values for each standardized residual (Z) value comparison, extracted from chi square test.}

\item{z.crit}{the critical Z value for the comparison of standardized residuals (Z), extracted from the chi square test.}

\item{sig.level}{the alpha value used to assess significance (default set to \code{0.05}).}

\item{insig}{glyphs to add on non-significant standardized residual (Z) values (default set to \code{"pch"}).}

\item{pch}{glyphs added to non-significant standardized residual (Z) values (default set to \code{4}).}

\item{pch.col}{color of pch glyphs (default set to \code{"black"}).}

\item{pch.cex}{size of pch glyphs (default set to \code{5}).}

\item{tl.cex}{size of text label for each category name for both variables (default set to \code{12}).}

\item{tl.col}{color of text label for each category name for both variables (default set to \code{"black"}).}

\item{tl.srt}{string rotation of text label for each category name for the variable on the x-axis (default set to \code{45}).}

\item{digits}{the number of decimal digits to be displayed in the plot (default set to \code{2}, but set to \code{3} if extracted from chi square test).}

\item{as.is}{determines how to handle dimnames, either left as strings (if set to \code{TRUE}), or converted (default set to \code{FALSE}).}
}
\value{
This function returns the chi square plot of standardized residuals for categories of \code{var1} by \code{var2} in data frame \code{df}, all of which are extracted from the chi square test.
}
\description{
This function plots a cell-by-cell chart (chiplot) on a given matrix of standardized residuals (Z) from a chi square test.
}
\examples{
data <- mtcars

x2 <- chi.sq(data,vs,am,post=TRUE)

chiplot(zmat = x2$z_mat,p.mat = x2$p_z_mat,z.crit = round(x2$z_crit, 4),
outline.color = "white",lab = TRUE,digits = 3)
}
