% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/platform.R
\name{vm}
\alias{vm}
\title{Retrieve a validmind (vm) connection object using reticulate}
\usage{
vm(
  api_key,
  api_secret,
  model,
  python_version,
  api_host = "http://localhost:3000/api/v1/tracking"
)
}
\arguments{
\item{api_key}{The ValidMind API key}

\item{api_secret}{The ValidMind API secret}

\item{model}{The ValidMind model}

\item{python_version}{The Python Version to use}

\item{api_host}{The ValidMind host, defaulting to local}
}
\value{
A validmind connection object, obtained from `reticulate`,
which orchestrates the connection to the ValidMind API
}
\description{
Retrieve a validmind (vm) connection object using reticulate
}
\examples{
\dontrun{
vm_r <- vm(
   api_key="<your_api_key_here>",
   api_secret="<your_api_secret_here>",
   model="<your_model_id_here>",
   python_version=python_version,
   api_host="https://api.dev.vm.validmind.ai/api/v1/tracking"
 )
}

}
