% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feasible.R
\name{detect_infeasible_rules}
\alias{detect_infeasible_rules}
\title{Detect which rules cause infeasibility}
\usage{
detect_infeasible_rules(x, weight = numeric(), ..., verbose = interactive())
}
\arguments{
\item{x}{\code{\link[validate:validator]{validate::validator()}} object with rules}

\item{weight}{optional named \code{\link[=numeric]{numeric()}} with weights. Unnamed variables in the weight are given the default
weight \code{1}.}

\item{...}{not used}

\item{verbose}{if \code{TRUE} it prints the infeasible rules that have been found.}
}
\value{
\code{character} with the names of the rules that are causing infeasibility.
}
\description{
Detect which rules cause infeasibility. This methods tries to remove the minimum number of rules to make the system
mathematically feasible. Note that this may not result in your desired system, because some rules may be more important
to you than others. This can be mitigated by supplying weights for the rules. Default weight is 1.
}
\examples{
rules <- validator( x > 0)

is_infeasible(rules)

# infeasible system!
rules <- validator( rule1 = x > 0
                  , rule2 = x < 0
                  )

is_infeasible(rules)

detect_infeasible_rules(rules, verbose=TRUE)

# but we want to keep rule1, so specify that it has an Inf weight
detect_infeasible_rules(rules, weight=c(rule1=Inf), verbose=TRUE)

# detect and remove
make_feasible(rules, weight=c(rule1=Inf), verbose = TRUE)

# find out the conflict with rule2
is_contradicted_by(rules, "rule2", verbose = TRUE)
}
\seealso{
Other feasibility: 
\code{\link{detect_boundary_cat}()},
\code{\link{detect_boundary_num}()},
\code{\link{detect_contradicting_if_rules}()},
\code{\link{is_contradicted_by}()},
\code{\link{is_infeasible}()},
\code{\link{make_feasible}()}
}
\concept{feasibility}
