% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vacuum_cleaner.R
\name{vacuum_cleaner}
\alias{vacuum_cleaner}
\title{Returns the residuals of a two-way table after removing systemic effects}
\usage{
vacuum_cleaner(x)
}
\arguments{
\item{x}{Two-way table to analyze (must be 3x3 or greater).}
}
\value{
Residuals of \code{x}
}
\description{
To remove systemic effects from values in a contingency table,
vacuum cleaner uses regression to identify the table's main effect
(dual regression), row effect (deviations of row
regression from dual regression), and column effect (deviations of
column regression from dual regression).

Regression is performed twice: First on the table's original values,
then on the resulting residuals. The output is a table of residuals
"vacuum cleaned" of likely systemic effects.
}
\examples{
vacuum_cleaner(table_8)
}
\references{
Tukey, John W. "The Future of Data Analysis."
\emph{The Annals of Mathematical Statistics},
\emph{33}(1), 1962, pp 1-67. \emph{JSTOR},
\url{https://www.jstor.org/stable/2237638}.
}
\seealso{
\code{\link[=funop]{funop()}}, \code{\link[=funor_funom]{funor_funom()}}
}
