% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coh_immunization.R
\name{get_immunization_vaccine}
\alias{get_immunization_vaccine}
\title{Construct Vaccine Name Associated to Immunizing Vaccine}
\usage{
get_immunization_vaccine(
  data_set,
  immunization_date_col,
  vacc_date_col,
  vacc_name_col,
  immunization_delay
)
}
\arguments{
\item{data_set}{\code{data.frame} with cohort information.}

\item{vacc_date_col}{Name of the column(s) that contain the vaccine dates.}

\item{vacc_name_col}{Name of the column(s) that contain custom vaccine
names for the vaccines (e.g. brand name, type of vaccine)}

\item{immunization_delay}{Characteristic time in days before the patient
is considered immune.}
}
\value{
Custom vaccine names of the immunizing vaccine.
}
\description{
This function is used in cases where several columns with
vaccine dates and different names are provided by the user. It returns a
column with the name of the vaccine used as immunizing. The parameters are
set in agreement with \code{get_immunization_date}.
}
\keyword{internal}
