% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getYieldCurve}
\alias{getYieldCurve}
\title{Download US Treasury yield curve data.}
\usage{
getYieldCurve(year = NULL, month = NULL,
  base = "http://data.treasury.gov/feed.svc/DailyTreasuryYieldCurveRateData",
  allowParallel = FALSE)
}
\arguments{
\item{year}{the desired year number or NULL for all years (default)}

\item{month}{the desired month number or NULL for all months (default)}

\item{base}{the base URL for the data service, defaulting to \url{http://data.treasury.gov/feed.svc/DailyTreasuryYieldCurveRateData}.  If the month or year arguments are not NULL, then the function modifies this URL to parameterize the download request.}

\item{allowParallel}{whether to allow \code{ldply} to use a registered parallel cluster.  FALSE by default.}
}
\value{
Class type \code{ustyc} containing update date \code{updated}, dataframe \code{df}, \code{month}, \code{year}, and \code{query} elements.  The \code{query} element value is the string used to call the data service for download.
}
\description{
Downloads US Treasury yield curve data from the US Treasury web site.
}
\details{
Forms a query to submit for US Treasury yield curve data, posting this query to the US Treasury web site's data feed service.  By default the download includes data yield data for 12 products from January 1, 1990, some of which are NA during this span.  The caller can pass parameters to limit the query to a certain year or year and month, but the full download is not especially large.  The download data from the service is in XML format.  This function transforms that data into a numeric data frame with treasury product items (constant maturity yields for 12 kinds of bills, notes, and bonds) as columns and dates as row names. The function returns a list which includes an item for this data frame as well as query-related values for reference and the update date from the service.  The data frame can be used as-is or converted easily to a time series format such as \code{xts}.
}
\examples{
\dontrun{
xlist = getYieldCurve()
summary(xlist)
}
}
\references{
\url{http://data.treasury.gov/feed.svc/DailyTreasuryYieldCurveRateData}
}
\seealso{
\url{http://cran.r-project.org/web/packages/FRBData/} for different interest rates and source.
}

