% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{un_roll_calls}
\alias{un_roll_calls}
\title{Data on each roll call of the United Nations General Assembly}
\format{
A data frame (specifically a tbl_df) with one row
for each roll call vote, and the following columns:
\describe{
  \item{rcid}{The roll call id; used to join with \code{\link{un_votes}}
  and \code{\link{un_roll_call_issues}}}
  \item{session}{Session number. The UN holds one session per year; these
  started in 1946}
  \item{importantvote}{Whether the vote was classified as important by the
  U.S. State Department report "Voting Practices in the United Nations".
  These classifications began with session 39}
  \item{date}{Date of the vote, as a Date vector}
  \item{unres}{Resolution code}
  \item{amend}{Whether the vote was on an amendment; coded only until
  1985}
  \item{para}{Whether the vote was only on a paragraph and not a resolution;
  coded only until 1985}
  \item{short}{Short description}
  \item{descr}{Longer description}
}
}
\source{
Erik Voeten "Data and Analyses of Voting in the UN General Assembly"
 Routledge Handbook of International Organization, edited by Bob Reinalda
  (published May 27, 2013)
  \url{https://dataverse.harvard.edu/dataset.xhtml?persistentId=hdl:1902.1/12379}
}
\usage{
un_roll_calls
}
\description{
Information on each roll call vote of the United Nations General Assembly.
}
\details{
The yes, no, and abstain columns that were present in the original
Voeten data were removed (since they can be retrieved from the
\code{\link{un_votes}} dataset)
}
\examples{

library(dplyr)

# combine with per-country-vote information
un_votes \%>\%
  inner_join(un_roll_calls, by = "rcid")

}
\keyword{datasets}
