% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot.univariateML}
\alias{plot.univariateML}
\alias{lines.univariateML}
\alias{points.univariateML}
\title{Plot, Lines and Points Methods for Maximum Likelihood Estimates}
\usage{
\method{plot}{univariateML}(x, range = NULL, kind = c("d", "p", "q"), ...)

\method{lines}{univariateML}(x, range = NULL, kind = c("d", "p", "q"), ...)

\method{points}{univariateML}(x, range = NULL, kind = c("d", "p", "q"), ...)
}
\arguments{
\item{x}{a \code{univariateML} object.}

\item{range}{range of \code{x} values to plot, i.e. \code{c(lower, upper)}.}

\item{kind}{can be \code{density}, \code{probability}, or \code{quantile}.}

\item{...}{parameters passed to \code{plot}, \code{lines}, or \code{points}.}
}
\value{
An invisible copy of \code{x}.
}
\description{
The \code{plot}, \code{lines}, and \code{points} methods for
\code{univariateML} objects.
}
\examples{
plot(mlweibull(datasets::precip), main = "Annual Precipitation in US Cities")
lines(mlgamma(datasets::precip), lty = 2)
rug(datasets::precip)
}
