% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlzip.R
\name{mlzip}
\alias{mlzip}
\title{Zero-inflated Poisson distribution maximum likelihood estimation}
\usage{
mlzip(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{Not currently in use.}
}
\value{
\code{mlzip} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{lambda} and \code{pi} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
For the density function of the zeero-inflated Poisson distribution see
\link[extraDistr:ZIP]{Zero-inflated Poisson distribution}.
}
\examples{
mlzip(corbet)
}
\references{
Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate Discrete Distributions (3rd ed.). Wiley-Blackwell.
}
\seealso{
\link[extraDistr:ZIP]{Zero-inflated Poisson distribution} for the density.
}
