% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlllogis.R
\name{mlllogis}
\alias{mlllogis}
\title{Log-logistic distribution maximum likelihood estimation}
\usage{
mlllogis(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{passed to \code{\link{mllogis}}.}
}
\value{
\code{mllogis} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{shape} and \code{rate} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
The maximum likelihood estimate of \code{shape} and \code{rate} are calculated
by transforming the data back to the logistic model and applying
\code{\link{mllogis}}.
}
\details{
For the density function of the log-logistic distribution see
\link[actuar:Loglogistic]{Loglogistic}
}
\examples{
mllnorm(precip)
}
\references{
Kleiber, C. and Kotz, S. (2003), Statistical Size Distributions
in Economics and Actuarial Sciences, Wiley.

Klugman, S. A., Panjer, H. H. and Willmot, G. E. (2012), Loss Models,
From Data to Decisions, Fourth Edition, Wiley.

Dutang, C., Goulet, V., & Pigeon, M. (2008). actuar: An R package for
actuarial science. Journal of Statistical Software, 25(7), 1-37.
}
\seealso{
\link[actuar:Loglogistic]{Loglogistic} for the log-logistic density.
}
