% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlburr.R
\name{mlburr}
\alias{mlburr}
\title{Burr distribution maximum likelihood estimation}
\usage{
mlburr(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{currently affects nothing.}
}
\value{
\code{mlburr} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{shape1} and \code{shape2} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
The maximum likelihood estimator fails to exist when the data contains no values
strictly smaller than 1. Then the likelihood converges
to the likelihood of the \link[=mlpareto]{Pareto distribution} in this case.
}
\details{
This function estimates the only the shape parameters of the Burr distribution.
The shape is set to 1.

For the density function of the Burr distribution see \link[actuar:Burr]{Burr}.
}
\examples{
mlburr(abalone$length)
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous
Univariate Distributions, Volume 1, Chapter 20. Wiley, New York.
}
\seealso{
\link[actuar:Burr]{Burr} for the Burr density.
}
