% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniRel.R
\name{uniRel}
\alias{uniRel}
\title{uniRel}
\usage{
uniRel(rel, b = NULL, corm)
}
\arguments{
\item{rel}{Vector of reliabilities of the tests}

\item{b}{Vector of weightings for the reliabilities; must match order of `rel`. Default: 1}

\item{corm}{Correlation matrix of the tests; must be square with 1s on the diagonal}
}
\value{
A single value of the class `numeric` representing the unified reliability estimate across multiple tests
}
\description{
A function for unifying the reliabilities of multiple tests
}
\examples{
rel = c(0.70, 0.90, 0.80)
b = c(1, 1, 1)
corm = matrix(c(1, 0.50, 0.35, 0.50, 1, 0.75, 0.35, 0.70, 1), nrow = 3, ncol = 3)
uniRel(rel, b, corm)

}
