% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/York.R
\docType{data}
\name{yorku_1}
\alias{yorku_1}
\title{Primary colors of the York University, Canada}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on \href{https://www.yorku.ca}{York}'s 
\href{https://www.yorku.ca/brand/}{Brand standards} (PDF).
}
\usage{
yorku_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{yorku_1} provides the three primary colors 
of the \href{https://www.yorku.ca}{York University}, Canada.
}
\details{
The 3 primary colors are
\code{"York red"} (defined as RGB 227/24/55, HEX #E31837),
\code{"white"} (defined as RGB 255/255/255, HEX #FFFFFF), and
\code{"black"} (defined as RGB 0/0/0, HEX #000000).

\code{yorku_1} uses the HEX color definitions.
}
\examples{
yorku_1
unikn::seecol(yorku_1, col_bg = "grey90", 
              main = "The primary colors of York University, CA") # view palette

}
\seealso{
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{ucalgary_warmgreys}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-24.
}
\concept{Canadian university color palettes}
\keyword{datasets}
