% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oxford.R
\docType{data}
\name{oxford_link}
\alias{oxford_link}
\title{Link colours of University of Oxford, England, UK}
\format{
An object of class \code{character} of length 5.
}
\source{
Colour definitions are based on the
\href{https://www.ox.ac.uk/public-affairs/style-guide/digital-style-guide}{Digital style guide}.
}
\usage{
oxford_link
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{oxford_link} provides the link colours 
of the \href{https://www.ox.ac.uk/}{University of Oxford}, England, UK.
}
\details{
Light blue is used to indicate general actions (links and buttons). 
Hence, it is also used in various navigational elements such as the block rollover effect 
on the drop down menus. 
However, many ever-present navigational links do not use this light blue link colour 
so as not to distract from the main page content and more contextual related links in the sidebar.
A distinctive red colour is used sparingly to highlight key/primary call to actions
This is to give it more visibility over other actions on the page of less importance.

The colours are
\code{"link"} (defined as HEX #3277ae),
\code{"link hover"} (defined as HEX #44687d),
\code{"alt_link_hover"} (defined as HEX #be0f34),
\code{"link_header"} (defined as HEX #70a9d6) and
\code{"link_overlay"} (defined as HEX #98c1e1),
}
\examples{
oxford_link
unikn::seecol(oxford_link, main = "Uni Oxford link colours") # view colour palette

}
\seealso{
\code{\link{oxford_brand}} for the brand colours of University of Oxford;
\code{\link{oxford_general}} for the general colours of University of Oxford;
\code{\link{oxford_shades}} for the shade colours of University of Oxford;
\code{\link{oxford_blog}} for the blog colours of University of Oxford;
\code{\link{oxford_graduate}} for the graduate colours of University of Oxford;
\code{\link{oxford_error}} for the error colours of University of Oxford;
\code{\link{oxford_socialmedia}} for the social media colours of University of Oxford;
\code{\link[unikn]{seecol}} for viewing and comparing colour palettes;
\code{\link[unikn]{usecol}} for using colour palettes;
\code{\link[unikn]{simcol}} for finding similar colours;
\code{\link[unikn]{newpal}} for defining new colour palettes;
\code{\link[unikn]{grepal}} for finding named colours.

Other English university color palettes: 
\code{\link{birmingham}},
\code{\link{lancaster_1}},
\code{\link{lancaster_2}},
\code{\link{oxford_blog}},
\code{\link{oxford_brand}},
\code{\link{oxford_error}},
\code{\link{oxford_general}},
\code{\link{oxford_graduate}},
\code{\link{oxford_shades}},
\code{\link{oxford_socialmedia}},
\code{\link{uni_manchester}}
}
\author{
\strong{unicol}, 2023-06-15.
}
\concept{English university color palettes}
\keyword{datasets}
