% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lund.R
\docType{data}
\name{lund_2}
\alias{lund_2}
\title{Pastel colours of the University of Lund, Sweden}
\format{
An object of class \code{character} of length 5.
}
\source{
Color definitions are based on \href{https://www.lu.se}{LU}'s staff guidelines on 
\href{https://www.staff.lu.se/support-and-tools/communication-and-graphic-profile/graphic-profile-and-logotype/colours}{Colour} (HTML).
}
\usage{
lund_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{lund_2} provides the five pastel colours  
of the \href{https://www.lu.se}{Lund University}, Sweden.
}
\details{
See \code{\link{lund_3}} for darker pastel colours of Lund University. 

\code{lund_2} is based on RGB color definitions.
}
\examples{
lund_2
unikn::seecol(lund_2, main = "Pastel colours of Lund University, Sweden")

}
\seealso{
\code{\link{lund_1}} for profile colours of Lund University; 
\code{\link{lund_3}} for darker pastel colours of Lund University; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Swedish university color palettes: 
\code{\link{gothenburg}},
\code{\link{lund_1}},
\code{\link{lund_3}},
\code{\link{stockholm_1}},
\code{\link{stockholm_2}},
\code{\link{uppsala}}
}
\author{
\strong{unicol}, 2023-10-12.
}
\concept{Swedish university color palettes}
\keyword{datasets}
