% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxCLPM.R
\name{xmu_equate_threshold_values}
\alias{xmu_equate_threshold_values}
\title{Equate Threshold Values Across Columns in a Model}
\usage{
xmu_equate_threshold_values(model, x_cols)
}
\arguments{
\item{model}{A model object that contains threshold values in its `deviations_for_thresh` slot.}

\item{x_cols}{A character vector specifying the names of the columns whose thresholds will be equated.}
}
\value{
The modified model object with equated threshold values across the specified columns.
}
\description{
This function sets the threshold values for multiple columns in a model to be equal to the threshold values of the first specified column. 
It is useful in contexts where consistent threshold values are needed across different variables for statistical modeling.
}
\examples{
\dontrun{
# Assumes `my_model` is a previously defined threshold model
# and has columns "var1", "var2", and "var3" in deviations_for_thresh$values
updated_model = xmu_equate_threshold_values(my_model, x_cols = c("var1", "var2", "var3"))
}

}
