% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_freq.R
\name{uplot_freq}
\alias{uplot_freq}
\title{Frequency Plot of a Selected Variable}
\usage{
uplot_freq(
  mfd,
  var = "14N",
  col = "grey",
  space = 0.5,
  width = 0.3,
  logo = TRUE,
  gg_size = 12,
  plotly = FALSE,
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{var}{Character. Name of the variable for which the frequency
distribution should be plotted (e.g. \code{"14N"}).}

\item{col}{Bar fill color.}

\item{space}{Not used (kept for backward compatibility).}

\item{width}{Bar width.}

\item{logo}{Logical. If TRUE, adds a UME caption.}

\item{gg_size}{Base text size for \code{theme_uplots()}. Default = 12.}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A ggplot object, or a plotly object when \code{plotly = TRUE}.
}
\description{
Creates a frequency plot (bar plot) for a selected variable in a molecular
formula dataset. Values are grouped and counted, then visualized as bars.
A unified UME plot theme is applied for consistent styling across all
uplot_* functions.
}
