% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{.prepare_peaklist_columns}
\alias{.prepare_peaklist_columns}
\title{Ensure required peaklist columns are present}
\usage{
.prepare_peaklist_columns(pl)
}
\arguments{
\item{pl}{A \code{data.table} representing a peaklist.}
}
\value{
A \code{data.table} with guaranteed core columns.
}
\description{
Internal helper for \code{as_peaklist()} that ensures essential structural
columns required for UME processing are present. Specifically:
\itemize{
\item If \code{file_id} is missing but a character column such as \code{file} or
\code{link_rawdata} exists, file_id is generated as a unique integer
per distinct value in that column.
\item If no such identifier exists, \code{file_id := 1L} is assigned.
\item Adds \code{peak_id} if missing (using \code{.I})
\item Converts \code{file_id} to integer type
}
}
\keyword{internal}
