% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_norm_int.R
\name{calc_norm_int}
\alias{calc_norm_int}
\title{Calculate Normalized Peak Intensities}
\usage{
calc_norm_int(
  mfd,
  ms_id = "file_id",
  peak_id = "peak_id",
  peak_magnitude = "i_magnitude",
  normalization = c("bp", "sum", "sum_ubiq", "sum_rank", "none"),
  n_rank = 200,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{ms_id}{Character; name of the column identifying individual spectra (default: \code{"file_id"}).}

\item{peak_id}{Character; name of the column identifying unique peaks (default: \code{"peak_id"}).}

\item{peak_magnitude}{Character; name of the column containing peak intensity values (default: \code{"i_magnitude"}).}

\item{normalization}{Character; normalization method to apply. One of \code{"bp"}, \code{"sum"}, \code{"sum_ubiq"}, \code{"sum_rank"}, \code{"none"}. Default is \code{"bp"}.}

\item{n_rank}{Integer; number of top-ranked peaks to use for \code{"sum_rank"} normalization (default: 200).}

\item{verbose}{logical; if \code{TRUE}, show progress messages.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A \code{data.table} identical to \code{mfd} but with additional columns:
\describe{
\item{norm_int}{Normalized peak intensity based on selected method.}
\item{int_ref}{Reference intensity used for normalization (e.g., sum, base peak).}
\item{n_assignments}{Number of formula assignments per peak (calculated internally).}
\item{n_occurrence}{Number of occurrences of each formula across all spectra (calculated internally).}
}
}
\description{
Computes normalized peak intensities for a molecular formula dataset and adds the results
as additional columns to the input \code{data.table} (\code{mfd}). It also calculates:
\itemize{
\item the number of molecular formula assignments per peak (\code{n_assignments})
\item the total occurrences of each formula across the dataset (\code{n_occurrence})
}

Normalized intensities are stored in a new column \code{norm_int}, and the reference
intensity used for normalization is stored in \code{int_ref}.

Supported normalization methods:
\itemize{
\item \code{"none"} – no normalization; raw peak intensities are copied to \code{norm_int}
\item \code{"bp"} – normalized to the base peak intensity per spectrum
\item \code{"sum"} – normalized by the total sum of intensities per spectrum
\item \code{"sum_ubiq"} – normalized by the sum of intensities of ubiquitous peaks across the dataset
\item \code{"sum_rank"} – normalized by the sum of the top \code{n_rank} most intense peaks per spectrum
\item \code{"euc"} – Euclidean normalization (optional, not implemented in current version)
}
}
\examples{
mfd_norm <- calc_norm_int(
  mfd = mf_data_demo,
  normalization = "sum_ubiq"
)
}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\concept{calculations}
