% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_indeces.R
\name{calc_ideg}
\alias{calc_ideg}
\title{Calculate Degradation Index (Ideg)}
\usage{
calc_ideg(
  mfd,
  mf_col = "mf",
  magnitude_col = "i_magnitude",
  grp = "file_id",
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{mf_col}{Character. The name of the column containing molecular formulas. Default is "mf".}

\item{magnitude_col}{Character. The name of the column containing magnitude values (absolute or relative). Default is "i_magnitude".}

\item{grp}{Character vector. Names of columns (e.g., sample or file identifiers)
used to aggregate results.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \code{data.table} with columns:
\itemize{
\item \code{grp}: Grouping variable.
\item \code{ideg}: Calculated degradation index (rounded to 3 decimals).
\item \code{ideg_n}: Number of assigned formulas used in the calculation.
}
}
\description{
This function calculates the degradation index ('Ideg') following Flerus et al. (2012). High Ideg values indicate 'older' marine DOM
(i.e., a higher contribution of peaks that correlate negatively with delta14C), while low values indicate 'younger' DOM
(i.e., a higher contribution of peaks that correlate positively with delta14C)./

Ideg is computed as the ratio of summed magnitudes for five negative (NEG) molecular formulas to the total summed magnitudes of five positive (POS)
and five negative (NEG) molecular formulas:

\deqn{Ideg = \frac{\sum{NEG}}{\sum{NEG} + \sum{POS}}}

The index ranges from 0 to 1 and is valid only if all required formulas (n = 10) are present. Ideg depends strongly on
the type of sample preparation, ionization method, and instrument settings, and should only be interpreted for relative
changes within the same dataset.
}
\examples{
# Create a minimal dataset containing all required POS and NEG formulas
library(data.table)

demo_ideg <- data.table(
  file_id = 1,
  mf = c(
    "C17H20O9", "C19H22O10", "C20H22O10", "C20H24O11", "C21H26O11",   # NEG
    "C13H18O7", "C14H20O7", "C15H22O7", "C15H22O8", "C16H24O8"        # POS
  ),
  i_magnitude = c(
    1200, 900, 1500, 700, 800,     # NEG intensities
    2000, 1800, 2200, 1600, 1900   # POS intensities
  )
)

calc_ideg(
  mfd = demo_ideg,
  mf_col = "mf",
  magnitude_col = "i_magnitude",
  grp = "file_id"
)
}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\concept{calculations}
