% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_exact_mass.R
\name{calc_exact_mass}
\alias{calc_exact_mass}
\title{Calculate Exact Monoisotopic Mass of a Molecule}
\usage{
calc_exact_mass(mfd, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A numeric vector of the calculated exact monoisotopic mass.
}
\description{
This function calculates the exact monoisotopic mass for each molecule
in a given data table based on the specified isotope composition. Exact masses of
elements and isotopes used in the calculation are retrieved from the \code{ume::masses} data,
based on data from NIST (https://www.nist.gov/pml/atomic-weights-and-isotopic-compositions-relative-atomic-masses).
}
\examples{
# Example with demo data
calc_exact_mass(mfd = mf_data_demo)
# Custom example
calc_exact_mass(data.table::data.table(c = 3, h = 8, o = 1))
}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\author{
Boris P. Koch
}
\concept{calculations}
