% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculFastSpectral_p.r
\name{ZPGaussianSimilarity}
\alias{ZPGaussianSimilarity}
\title{Similarity matrix with local scale parameter}
\usage{
ZPGaussianSimilarity(data, K)
}
\arguments{
\item{data}{a matrix or numeric data frame.}

\item{K}{number of neighbours considered to compute scale parameters.}
}
\value{
The matrix of similarity.
}
\description{
Compute and return the similarity matrix of a data frame using gaussian kernel with a local scale parameter for each data point, 
rather than a unique scale parameter.
}
\examples{
x <- rbind(matrix(rnorm(50, mean = 0, sd = 0.3), ncol = 2))
similarity<-ZPGaussianSimilarity(x,7)
}
\references{
Zelnik-Manor, Lihi, and Pietro Perona. "Self-tuning spectral clustering." Advances in neural information processing systems. 2004.
}

