% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pFisher.R
\name{pFisher}
\alias{pFisher}
\title{Combined p-value from Fisher's method}
\usage{
pFisher(mu = 0, t1, t2, se1, se2, alternative = "greater")
}
\arguments{
\item{mu}{Null value. Defaults to \code{0}}

\item{t1}{Parameter estimate from trial 1}

\item{t2}{Parameter estimate from trial 2}

\item{se1}{Standard error of the parameter estimate from trial 1}

\item{se2}{Standard error of the parameter estimate from trial 2}

\item{alternative}{One-sided alternative hypothesis. Can be either
\code{"greater"} or \code{"less"}. Defaults to \code{"greater"}}
}
\value{
The combined p-value based on Fisher's method
}
\description{
This function computes the combined p-value based on two
    parameter estimates using the Fisher's method (also known as the product
    method)
}
\examples{
## p-value for H0: logRR = 0 in RESPIRE trials
pFisher(mu = 0, t1 = -0.4942, t2 = -0.1847, se1 = 0.1833, se2 = 0.1738,
        alternative = "less")

}
\seealso{
\code{\link{muFisher}}
}
\author{
Samuel Pawel
}
