% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss2MixedCountContinuous.R
\name{ss2MixedCountContinuous}
\alias{ss2MixedCountContinuous}
\title{Sample Size Calculation for Two Co-Primary Endpoints: One Count and One Continuous}
\usage{
ss2MixedCountContinuous(
  r1,
  r2,
  nu,
  t,
  mu1,
  mu2,
  sd,
  r,
  rho1,
  rho2,
  alpha,
  beta
)
}
\arguments{
\item{r1}{Mean count rate in group 1 for the count endpoint}

\item{r2}{Mean count rate in group 2 for the count endpoint}

\item{nu}{Dispersion parameter for the negative binomial distribution (nu > 0).
Smaller values indicate greater overdispersion}

\item{t}{Follow-up time period}

\item{mu1}{Mean for group 1 for the continuous endpoint}

\item{mu2}{Mean for group 2 for the continuous endpoint}

\item{sd}{Common standard deviation for the continuous endpoint}

\item{r}{Allocation ratio n1/n2 where n1 is sample size for group 1}

\item{rho1}{Correlation between count and continuous endpoints in group 1}

\item{rho2}{Correlation between count and continuous endpoints in group 2}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{beta}{Type II error rate (typically 0.1 or 0.2). Power = 1 - beta}
}
\value{
A data frame with the following columns:
\item{r1, r2}{Count rates}
\item{nu}{Dispersion parameter}
\item{t}{Follow-up time}
\item{mu1, mu2}{Means for continuous endpoint}
\item{sd}{Standard deviation for continuous endpoint}
\item{r}{Allocation ratio}
\item{rho1, rho2}{Correlations}
\item{alpha}{One-sided significance level}
\item{beta}{Type II error rate}
\item{n1}{Required sample size for group 1}
\item{n2}{Required sample size for group 2}
\item{N}{Total sample size (n1 + n2)}
}
\description{
Determines the sample size for a two-arm superiority trial with two co-primary
endpoints where one is a count (negative binomial) and one is continuous (normal),
to achieve a specified power at a given significance level.
}
\details{
This function implements the sample size calculation for mixed count-continuous
co-primary endpoints following the methodology in Homma and Yoshida (2024).

The sequential search algorithm (Homma and Yoshida 2025, Algorithm 1) is used:

\strong{Step 1:} Initialize with sample sizes from single endpoint formulas.

\strong{Step 2:} Use sequential search:
\itemize{
\item Calculate power at initial sample size
\item If power >= target: decrease n2 until power < target, then add 1 back
\item If power < target: increase n2 until power >= target
}

\strong{Step 3:} Return final sample sizes.

\strong{Negative Binomial Distribution:}
The count endpoint follows a negative binomial distribution NB(lambda, nu) where:
\itemize{
\item lambda = r * t is the mean count
\item nu is the dispersion parameter
\item Variance = lambda + lambda^2 / nu
}

\strong{Correlation:}
The correlations rho1 and rho2 must satisfy feasibility constraints that depend
on the parameters. Use \code{\link{corrbound2MixedCountContinuous}} to check
valid correlation bounds.
}
\examples{
# Sample size calculation for count and continuous endpoints
ss2MixedCountContinuous(
  r1 = 1.0,
  r2 = 1.25,
  nu = 0.8,
  t = 1,
  mu1 = -50,
  mu2 = 0,
  sd = 250,
  r = 1,
  rho1 = 0.4,
  rho2 = 0.4,
  alpha = 0.025,
  beta = 0.2
)

# With different dispersion parameter (more overdispersion)
ss2MixedCountContinuous(
  r1 = 1.0,
  r2 = 1.25,
  nu = 0.5,
  t = 1,
  mu1 = -50,
  mu2 = 0,
  sd = 250,
  r = 1,
  rho1 = 0.4,
  rho2 = 0.4,
  alpha = 0.025,
  beta = 0.2
)

}
\references{
Homma, G., & Yoshida, T. (2024). Sample size calculation for count and
continuous multiple co-primary endpoints. \emph{Pharmaceutical Statistics},
23(3), 372-388.

Homma, G., & Yoshida, T. (2025). Exact power and sample size in clinical
trials with two co-primary binary endpoints. \emph{Statistical Methods in
Medical Research}, 34(1), 1-19.
}
