% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glgp.R
\name{twingp}
\alias{twingp}
\title{A Fast Global-Local Gaussian Process Approximation}
\usage{
twingp(
  x,
  y,
  x_test,
  nugget = TRUE,
  twins = 5,
  g_num = NULL,
  l_num = NULL,
  v_num = NULL,
  num_threads = NULL
)
}
\arguments{
\item{x}{\code{n * d} numeric matrix representing the training features}

\item{y}{\code{n * 1} response vector corresponding to \code{x}}

\item{x_test}{\code{t * d} numeric matrix representing the \code{t} testing locations}

\item{nugget}{Boolean indicating if a nugget to model observation noise is included in the model, the default is \code{True}}

\item{twins}{Number of twinning samples computed to identify the best set of global points, the default is \code{5}}

\item{g_num}{Number of global points included in the model, the default is \code{min(50 * d, max(sqrt(n), 10 * d))}}

\item{l_num}{Number of local points included in the model, the default is \code{max(25, 3 * d)}}

\item{v_num}{Number of validation points, the default is \code{2 * g_num}}

\item{num_threads}{Number of threads for parallel computation, the default is all available threads}
}
\value{
A list of two \code{t * 1} vectors \code{mu}, and \code{sigma} representing the mean prediction and associated standard error corresponding to \code{x_test}
}
\description{
A Fast Global-Local Gaussian Process Approximation
}
\details{
We employ a combined global-local approach in building the Gaussian process approximation. Our framework uses a subset-of-data approach where the subset is a union of a set of global points designed to capture the global trend in the data, and a set of local points specific to a given testing location. We use \code{Twinning} (Vakayil and Joseph, 2022) to identify the set of global points. The local points are identified as the nearest neighbors to the testing location. The correlation function is also modeled as a combination of a global, and a local kernel. For further details on the methodology, please refer to Vakayil and Joseph (2024).
}
\examples{
grlee12 = function(x) {
  term1 = sin(10 * pi * x) / (2 * x)
  term2 = (x - 1)^4
  y = term1 + term2
  return(y)
}

x = matrix(seq(0.5, 2.5, length=500), ncol=1)
y = apply(x, 1, grlee12) + rnorm(nrow(x)) * 0.1
x_test = matrix(seq(0.5, 2.5, length=2000), ncol=1)
y_test = apply(x_test, 1, grlee12)

result = twingp(x, y, x_test, num_threads=2)
rmse = sqrt(mean((y_test - result$mu)^2))

}
\references{
Vakayil, A., & Joseph, V. R. (2024). A Global-Local Approximation Framework for Large-Scale Gaussian Process Modeling. Technometrics, 66(2), 295-305.

Vakayil, A., & Joseph, V. R. (2022). Data Twinning. Statistical Analysis and Data Mining: The ASA Data Science Journal, 15(5), 598-610.
}
